package gov.va.vamf.scheduling.direct.datalayer.facility;

import gov.va.vamf.scheduling.direct.domain.CustomFriendlyText;
import gov.va.vamf.scheduling.direct.domain.CustomFriendlyTexts;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collection;

@Service
public class CustomFriendlyTextService {
    @Resource
    private CustomFriendlyTextRepository customFriendlyTextRepository;

    public CustomFriendlyText fetchByInstitutionCode(String institutionCode) {
        return customFriendlyTextRepository.findBySiteCode(institutionCode);
    }

    public CustomFriendlyTexts fetchByInstitutionCodes(Collection<String> institutionCodes) {
        return customFriendlyTextRepository.findBySiteCodeIn(institutionCodes);
    }

    public CustomFriendlyTexts fetchAll() {
        return customFriendlyTextRepository.findAll();
    }

}
